<?php

namespace App\Contacts\Controllers;

use App\Contacts\Actions\PaginateCustomers;
use App\Conversations\Models\Conversation;
use Common\Core\BaseController;

class CustomersController extends BaseController
{
    public function index()
    {
        $this->authorize('index', Conversation::class);

        $params = request()->all();

        return $this->success([
            'pagination' => (new PaginateCustomers($params))->execute(),
        ]);
    }
}
