import {message} from '@ui/i18n/message';

export const supportedBackends = [
  {
    type: 'local',
    label: message('Local Disk (Default)'),
  },
  {
    type: 's3',
    label: message('Amazon S3'),
  },
  {
    type: 'other_s3',
    label: message('S3 API compatible provider'),
  },
  {
    type: 'backblaze',
    label: message('Backblaze'),
  },
  {
    type: 'webdav',
    label: message('WebDAV'),
  },
  {
    type: 'ftp',
    label: message('FTP'),
  },
  {
    type: 'digitalocean',
    label: message('DigitalOcean Spaces'),
  },
  {
    type: 'dropbox',
    label: message('Dropbox'),
  },
];

type BackendType = (typeof supportedBackends)[number]['type'];

export type BackendFormValue = {
  name: string;
  type: BackendType;
  root?: string;
  credentials: Record<BackendType, Record<string, string | number>>;
};
