import {FormTextField} from '@ui/forms/input-field/text-field/text-field';
import {FormSwitch} from '@ui/forms/toggle/switch';
import {Trans} from '@ui/i18n/trans';

type S3FormProps = {
  isInvalid?: boolean;
  formPrefix: string;
  showEndpointField?: boolean;
};
export function S3Form({
  isInvalid,
  formPrefix,
  showEndpointField,
}: S3FormProps) {
  return (
    <div>
      {showEndpointField && (
        <FormTextField
          size="sm"
          className="mb-20"
          invalid={isInvalid}
          name={`credentials.${formPrefix}.endpoint`}
          label={<Trans message="Endpoint" />}
        />
      )}
      <FormTextField
        size="sm"
        invalid={isInvalid}
        className="mb-20"
        name={`credentials.${formPrefix}.key`}
        label={<Trans message="Access key" />}
        required
      />
      <FormTextField
        size="sm"
        invalid={isInvalid}
        className="mb-20"
        name={`credentials.${formPrefix}.secret`}
        label={<Trans message="Secret key" />}
        required
      />
      <FormTextField
        size="sm"
        invalid={isInvalid}
        className="mb-20"
        name={`credentials.${formPrefix}.region`}
        label={<Trans message="Region" />}
        placeholder="us-east-1"
      />
      <FormTextField
        size="sm"
        className="mb-20"
        invalid={isInvalid}
        name={`credentials.${formPrefix}.bucket`}
        label={<Trans message="Bucket" />}
        required
      />
      <FormSwitch
        size="sm"
        name={`credentials.${formPrefix}.direct_upload`}
        description={
          <Trans message="Upload files directly from user's browser to cloud storage, bypassing your server. This improves upload speeds and reduces server bandwidth usage." />
        }
      >
        <Trans message="Enable direct upload" />
      </FormSwitch>
    </div>
  );
}
