import {apiClient} from '@common/http/query-client';
import {showHttpErrorToast} from '@common/http/show-http-error-toast';
import {useMutation} from '@tanstack/react-query';
import {message} from '@ui/i18n/message';
import {toast} from '@ui/toast/toast';

export function useRemoveAvatar({user}: {user: {id: number}}) {
  return useMutation({
    mutationFn: () =>
      apiClient.delete(`users/${user.id}/avatar`).then(r => r.data),
    onSuccess: () => {
      toast(message('Removed avatar'));
    },
    onError: err => showHttpErrorToast(err),
  });
}
