import type {NotificationListItemProps} from '@common/notifications/notification-list';
import {MessageDescriptor} from '@ui/i18n/message-descriptor';
import React, {ComponentType} from 'react';

export interface AdConfig {
  slot: string;
  description: MessageDescriptor;
  image: string;
}

export interface TagType {
  name: string;
  system?: boolean;
}

export interface CustomPageType {
  type: string;
  label: MessageDescriptor;
}

export interface RoleType {
  type: string;
  label: MessageDescriptor;
  permission_type?: string;
}

export interface HomepageOption {
  label: MessageDescriptor;
  value: string;
}

export interface SiteConfigContextValue {
  auth: {
    redirectUri: string;
    // redirect uri to use when homepage is set to login page, to avoid infinite loop
    secondaryRedirectUri?: string;
    adminRedirectUri: string;
    getUserProfileLink?: (user: {id: number | string; name: string}) => string;
  };
  notifications: {
    renderMap?: Record<string, ComponentType<NotificationListItemProps>>;
  };
  tags: {
    types: TagType[];
  };
  customPages: {
    types: CustomPageType[];
  };
  roles?: {
    types?: RoleType[];
  };
  settings?: {
    showIncomingMailMethod?: boolean;
  };
  admin: {
    ads: AdConfig[];
    channelsDocsLink?: string;
  };
  demo: {
    loginPageDefaults: 'singleAccount' | 'randomAccount';
    email?: string;
    password?: string;
  };
  homepage: {
    options: HomepageOption[];
  };
}

export const SiteConfigContext = React.createContext<SiteConfigContextValue>(
  null!,
);
