<?php namespace Common\Core\Install;

use Common\Core\BaseController;
use Common\Settings\DotEnvEditor;
use Exception;

class UpdateController extends BaseController
{
    public function __construct()
    {
        $disableUpdateAuth =
            (new DotEnvEditor())->load()['disable_update_auth'] ?? false;
        if (
            !$disableUpdateAuth &&
            version_compare(config('app.version'), $this->getAppVersion()) === 0
        ) {
            $this->middleware('isAdmin');
        }
    }

    public function show()
    {
        $data = (new CheckSiteHealth())->execute();
        return view('common::install/update')->with($data);
    }

    public function performUpdate()
    {
        (new UpdateActions())->execute();

        return view('common::install/update-complete');
    }

    private function getAppVersion(): string
    {
        try {
            return (new DotEnvEditor('env.example'))->load()['app_version'];
        } catch (Exception $e) {
            return config('app.version');
        }
    }
}
