<?php

namespace Common\Database\Traits;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

trait AddsIndexToExistingTable
{
    protected function addIndexIfDoesNotExist(Blueprint $table, string $column)
    {
        $tableName = $table->getTable();
        $indexesFound = Schema::getIndexListing($tableName);
        if (!in_array("{$tableName}_{$column}_index", $indexesFound)) {
            $table->index($column);
        }
    }

    protected function removeIndex(Blueprint $table, string $indexName)
    {
        if (str_ends_with($indexName, '_unique')) {
            $this->removeUniqueIndex($table, $indexName);
        } else {
            $tableName = $table->getTable();
            $indexesFound = Schema::getIndexListing($tableName);
            if (in_array($indexName, $indexesFound)) {
                $table->dropIndex($indexName);
            }
        }
    }

    protected function removeUniqueIndex(Blueprint $table, string $indexName)
    {
        $tableName = $table->getTable();
        $indexesFound = Schema::getIndexListing($tableName);
        if (in_array($indexName, $indexesFound)) {
            $table->dropUnique($indexName);
        }
    }
}
