<?php

namespace Common\Files\S3;

use Common\Core\BaseController;
use Common\Files\Actions\CreateFileEntry;
use Common\Files\Events\FileUploaded;
use Common\Files\FileEntry;
use Common\Files\FileEntryPayload;
use Common\Files\Middleware\FileUploadMiddlewareResolver;

class S3FileEntryController extends BaseController
{
    public function store()
    {
        $validatedData = $this->validate(request(), [
            'clientExtension' => 'required|string',
            'clientMime' => 'nullable|string|max:255',
            'clientName' => 'required|string',
            'disk' => 'string',
            'diskPrefix' => 'string',
            'filename' => 'required|string',
            'parentId' => 'nullable|exists:file_entries,id',
            'relativePath' => 'nullable|string',
            'workspaceId' => 'nullable|int',
            'size' => 'required|int',
            // todo: make required
            'uploadType' => 'string',
            'backendId' => 'string',
        ]);

        $payload = new FileEntryPayload($validatedData);

        $this->authorize('store', [FileEntry::class, $payload->parentId]);

        $fileEntry = app(CreateFileEntry::class)->execute($payload);

        $middleware = (new FileUploadMiddlewareResolver())->resolve(
            request('middleware'),
        );

        $fileEntry = $middleware->handle($fileEntry, $validatedData);

        event(new FileUploaded($fileEntry));

        return $this->success(['fileEntry' => $fileEntry]);
    }
}
