<?php

namespace Common\Files\S3;

use Carbon\Carbon;
use Common\Core\BaseController;
use Common\Files\Actions\FileUploadValidator;
use Common\Files\S3\InteractsWithS3Api;

class S3SimpleUploadController extends BaseController
{
    use InteractsWithS3Api;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function presignPost()
    {
        $fileKey = $this->buildFileKey();

        // todo: validate that uploadType and backendId are specified, here and in other places
        $errors = (new FileUploadValidator())->validate(
            fileSize: request('size'),
            extension: request('extension'),
            mime: request('mime'),
        );
        if ($errors) {
            abort(422, $errors->first());
        }

        $command = $this->getClient()->getCommand('PutObject', [
            'Bucket' => $this->getBucket(),
            'ContentType' => request()->input('mime'),
            'Key' => $fileKey,
            'ACL' => $this->getAcl(),
        ]);

        $uri = $this->getClient()
            ->createPresignedRequest($command, Carbon::now()->addHour())
            ->getUri();

        return $this->success([
            'url' => $uri,
            'key' => $fileKey,
            'acl' => $this->getAcl(),
        ]);
    }
}
