<?php

namespace Common\Settings\Validators;

use App\Models\User;
use Exception;
use Illuminate\Support\Arr;
use Laravel\Scout\Builder;
use Laravel\Scout\EngineManager;
use Matchish\ScoutElasticSearch\ElasticSearchServiceProvider;
use Matchish\ScoutElasticSearch\Engines\ElasticSearchEngine;
use Throwable;

class SearchConfigValidator
{
    const KEYS = ['scout_driver'];

    public function fails($settings)
    {
        $engineName = Arr::get(
            $settings,
            'scout_driver',
            config('scout.driver'),
        );
        $manager = app(EngineManager::class);

        if (isset($settings['algolia_app_id'])) {
            config()->set('scout.algolia.id', $settings['algolia_app_id']);
        }
        if (isset($settings['algolia_secret'])) {
            config()->set('scout.algolia.secret', $settings['algolia_secret']);
        }

        if (
            $engineName === 'mysql' &&
            Arr::get($settings, 'scout_mysql_mode') !== 'fulltext'
        ) {
            return false;
        }

        // register elastic search provider, if not registered already
        if (
            $engineName === ElasticSearchEngine::class &&
            empty(app()->getProviders(ElasticSearchServiceProvider::class))
        ) {
            app()->register(ElasticSearchServiceProvider::class);
        }

        $results = $manager->engine($engineName)->search(
            app(Builder::class, [
                'model' => new User(),
                'query' => 'test',
            ]),
        );
        if (!$results) {
            return $this->getDefaultErrorMessage();
        }
    }

    /**
     * @param Exception|Throwable $e
     * @return array
     */
    private function getErrorMessage($e)
    {
        $message = $e->getMessage();
        return [
            'search_group' => "Could not enable this search method: $message",
        ];
    }

    /**
     * @return array
     */
    private function getDefaultErrorMessage()
    {
        return ['search_group' => 'Could not enable this search method.'];
    }
}
